% DESCRIPTION:
%       subscript to initialise movie parameters
%
% ABOUT:
%       author      - Bradley Treeby
%       date        - 21st February 2011
%       last update - 20th December 2011
%       
% This function is part of the k-Wave Toolbox (http://www.k-wave.org)
% Copyright (C) 2009, 2010, 2011 Bradley Treeby and Ben Cox

% This file is part of k-Wave. k-Wave is free software: you can
% redistribute it and/or modify it under the terms of the GNU Lesser
% General Public License as published by the Free Software Foundation,
% either version 3 of the License, or (at your option) any later version.
% 
% k-Wave is distributed in the hope that it will be useful, but WITHOUT ANY
% WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
% FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for
% more details. 
% 
% You should have received a copy of the GNU Lesser General Public License
% along with k-Wave. If not, see <http://www.gnu.org/licenses/>.

% force getframe compatability with dual monitors
movegui(img);

% define frame index
frame_index = 1;

% calculate the total number of movie frames (the additional two frames
% come from storing the first and last time steps)
n_frames = floor(length(kgrid.t_array) / plot_freq) + 2;

% preallocate movie structure.
movie_frames(1:n_frames) = struct('cdata', [], 'colormap', []);

% save the first frame if in forward mode
if ~time_rev
    switch kgrid.dim
        case 1

            % create plot variable
            p_plot = p(x1:x2);

            % update plot
            plot(kgrid.x(x1:x2)*scale, p_plot);

            % update plot scale if set to automatic or log
            if plot_scale_auto || plot_scale_log
                kspaceFirstOrder_adjustPlotScale;
            end

            % add display mask onto plot
            if ~(strcmp(display_mask, 'default') || strcmp(display_mask, 'off'))
                hold on;
                plot(kgrid.x(x1:x2)*scale, display_mask(x1:x2).*(plot_scale(2) - plot_scale(1)) + plot_scale(1), 'k-');
                hold off
            end        

            % set plot options
            xlabel(['x-position [' prefix 'm]']);
            set(gca, 'YLim', plot_scale);        

        case 2

            % create plot variable
            p_plot = p(x1:x2, y1:y2);          

            % update plot scale if set to automatic or log
            if plot_scale_auto || plot_scale_log
                kspaceFirstOrder_adjustPlotScale;
            end     

            % add display mask onto plot
            if strcmp(display_mask, 'default')
                p_plot(double(sensor.mask(x1:x2, y1:y2)) == 1) = plot_scale(2);
            elseif ~strcmp(display_mask, 'off')
                p_plot(display_mask(x1:x2, y1:y2) ~= 0) = plot_scale(2);
            end

            if strcmp(movie_type, 'frame')        
                if mesh_plot
                    % update plot using a mesh without axes
                    mesh(kgrid.y_vec(y1:y2)*scale, kgrid.x_vec(x1:x2)*scale, p_plot, 'EdgeColor', 'Black');
                    axis image;
                    axis off;

                    % assign plot scale as z limits          
                    set(gca, 'ZLim', plot_scale);
                else
                    % update plot
                    imagesc(kgrid.y_vec(y1:y2)*scale, kgrid.x_vec(x1:x2)*scale, p_plot, plot_scale);
                    colormap(COLOR_MAP);
                    ylabel(['x-position [' prefix 'm]']);
                    xlabel(['y-position [' prefix 'm]']);
                    axis image;
                end         
            else        

                % scale the image data from 1 -> length(COLOR_MAP) using the
                % plot_scale used for the simulation animation
                p_plot(p_plot > plot_scale(2)) = plot_scale(2);
                p_plot(p_plot < plot_scale(1)) = plot_scale(1);    

                % apply the scaling
                p_plot = (length(COLOR_MAP) - 1).*(p_plot + abs(plot_scale(1)))./(plot_scale(2) + abs(plot_scale(1))) + 1;

                % save the movie frame
                movie_frames(frame_index) = im2frame(p_plot, COLOR_MAP);

            end

        case 3

            % create plot variable
            p_plot = p(x1:x2, y1:y2, z1:z2);       

            % update plot scale if set to automatic or log
            if plot_scale_auto || plot_scale_log
                kspaceFirstOrder_adjustPlotScale;
            end         

            % add display mask onto plot
            if strcmp(display_mask, 'default')
                p_plot(sensor.mask(x1:x2, y1:y2, z1:z2) ~= 0) = plot_scale(2);
            elseif ~strcmp(display_mask, 'off')
                p_plot(display_mask(x1:x2, y1:y2, z1:z2) ~= 0) = plot_scale(2);
            end

            % update plot
            planeplot(scale*kgrid.x_vec(x1:x2), scale*kgrid.y_vec(y1:y2), scale*kgrid.z_vec(z1:z2), p_plot, '', plot_scale, prefix, COLOR_MAP);

    end
    
    if ~(kgrid.dim == 2 && strcmp(movie_type, 'image'))
        
        % force plot update
        drawnow;        

        % set background color to white
        set(gcf, 'Color', [1 1 1]);

        % save the movie frame
        movie_frames(frame_index) = getframe(gcf);
        
    end

    % update frame index
    frame_index  = frame_index  + 1;
end
